/******************************************************************************/
class ToggleDrawObjects : BaseEvent
{
public:
            ToggleDrawObjects();
   virtual ~ToggleDrawObjects();
   
   virtual void create(Object &obj); 
   virtual void AfterCreate(      );
   
private:

   virtual void CallTriggeredAction();
   virtual void StopTriggeredAction();
   
   void ToggleDraw(bool draw);

   bool m_ShouldDraw;
   Memc<UID> m_MeshIDs;
   Memc<StaticToggleable*> m_Meshes;
};
/******************************************************************************/
ToggleDrawObjects::ToggleDrawObjects() : BaseEvent(), m_ShouldDraw(false)                      
{
   
}
ToggleDrawObjects::~ToggleDrawObjects()
{
   
}
/******************************************************************************/
void ToggleDrawObjects::create(Object &obj)
{
   // Getting the parameters from the object in the world
   if(Param *p = obj.findParam("Draw"))  m_ShouldDraw = p.asBool();
   
   // Get mesh1 to mesh9; add more if needed
   for(int i = 1; i <= 9; ++i)
      if(Param *p = obj.findParam(S+"Mesh" + i + "UID")) 
         if(p.asID().valid()) m_MeshIDs.add(p.asID());
       
   super.create(obj); // Create the BaseEvent params too
}
/******************************************************************************/
void ToggleDrawObjects::AfterCreate()
{
   REPAD(i, staticToggleables)
      REPAD(j, m_MeshIDs)
         if(staticToggleables[i].id() == m_MeshIDs[j]) 
            m_Meshes.add(&staticToggleables[i]); 
            
   DEBUG_ASSERT(m_MeshIDs.elms() == m_Meshes.elms(), "ToggleDrawObjects: Not all meshes were found in the scene");
}
/******************************************************************************/
// This method is called when the event was triggered, taking the delay into account
void ToggleDrawObjects::CallTriggeredAction()
{
   ToggleDraw(m_ShouldDraw); // Set visible/hidden
}

// This method is called when the duration of the event has been reached
void ToggleDrawObjects::StopTriggeredAction()
{
   // If m_Duration isn't -1, the object can become hidden/visible again
   ToggleDraw(!m_ShouldDraw); 
}
/******************************************************************************/
void ToggleDrawObjects::ToggleDraw(bool draw)
{   
   REPA(m_Meshes)
      m_Meshes[i]->SetDraw(draw);  
         
   // If you want to be able to toggle visibility on more different objects (like animatable, ..),
   // then you can just add the SetDraw() functionality to those as well. Just like with the StateToggleable.
}